/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.UIManager;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewConfig;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.view.ViewRootImpl;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ViewGroup
extends View
implements ViewParent {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    static final int FLAG_USE_CHILD_DRAWING_ORDER = 1024;
    private static final int FLAG_ADD_STATES_FROM_CHILDREN = 8192;
    private static final int FLAG_DISALLOW_INTERCEPT = 524288;
    private int mGroupFlags;
    private View[] mChildren = new View[12];
    private int mChildrenCount = 0;
    private float[] mTempPosition;
    private TouchTarget mFirstTouchTarget;
    private HoverTarget mFirstHoverTarget;
    private boolean mHoveredSelf;

    @Override
    protected void dispatchDraw(@Nonnull Canvas canvas) {
        boolean doTranslate;
        boolean bl = doTranslate = this.getScrollX() != 0.0f || this.getScrollY() != 0.0f;
        if (doTranslate) {
            canvas.save();
            canvas.translate(-this.getScrollX(), -this.getScrollY());
        }
        View[] views = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            views[i].draw(canvas);
        }
        if (doTranslate) {
            canvas.restore();
        }
    }

    @Override
    public final void layout(int left, int top, int right, int bottom) {
        super.layout(left, top, right, bottom);
    }

    @Override
    protected abstract void onLayout(boolean var1);

    private int getAndVerifyPreorderedIndex(int childrenCount, int i, boolean customOrder) {
        int childIndex;
        if (customOrder) {
            int childIndex1 = this.getChildDrawingOrder(childrenCount, i);
            if (childIndex1 >= childrenCount) {
                throw new IndexOutOfBoundsException("getChildDrawingOrder() returned invalid index " + childIndex1 + " (child count is " + childrenCount + ")");
            }
            childIndex = childIndex1;
        } else {
            childIndex = i;
        }
        return childIndex;
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent event) {
        boolean newHoveredSelf;
        int action = event.getAction();
        boolean intercepted = this.onInterceptHoverEvent(event);
        event.setAction(action);
        boolean handled = false;
        HoverTarget firstOldHoverTarget = this.mFirstHoverTarget;
        this.mFirstHoverTarget = null;
        if (!intercepted && action != 10 && this.mChildrenCount != 0) {
            float x = event.getX();
            float y = event.getY();
            View[] children = this.mChildren;
            int childrenCount = this.mChildrenCount;
            boolean customOrder = this.isChildrenDrawingOrderEnabled();
            HoverTarget lastHoverTarget = null;
            for (int i = childrenCount - 1; i >= 0; --i) {
                boolean wasHovered;
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(null, children, childIndex);
                if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null)) continue;
                HoverTarget hoverTarget = firstOldHoverTarget;
                HoverTarget predecessor = null;
                while (true) {
                    if (hoverTarget == null) {
                        hoverTarget = HoverTarget.obtain(child);
                        wasHovered = false;
                        break;
                    }
                    if (hoverTarget.child == child) {
                        if (predecessor != null) {
                            predecessor.next = hoverTarget.next;
                        } else {
                            firstOldHoverTarget = hoverTarget.next;
                        }
                        hoverTarget.next = null;
                        wasHovered = true;
                        break;
                    }
                    predecessor = hoverTarget;
                    hoverTarget = hoverTarget.next;
                }
                if (lastHoverTarget != null) {
                    lastHoverTarget.next = hoverTarget;
                } else {
                    this.mFirstHoverTarget = hoverTarget;
                }
                lastHoverTarget = hoverTarget;
                if (action == 9) {
                    if (!wasHovered) {
                        handled = this.dispatchTransformedGenericPointerEvent(event, child);
                    }
                } else if (action == 7) {
                    if (!wasHovered) {
                        event.setAction(9);
                        handled = this.dispatchTransformedGenericPointerEvent(event, child);
                        event.setAction(action);
                    }
                    handled |= this.dispatchTransformedGenericPointerEvent(event, child);
                }
                if (handled) break;
            }
        }
        while (firstOldHoverTarget != null) {
            View child = firstOldHoverTarget.child;
            if (action == 10) {
                handled |= this.dispatchTransformedGenericPointerEvent(event, child);
            } else {
                if (action == 7) {
                    boolean hoverExitPending = event.isHoverExitPending();
                    event.setHoverExitPending(true);
                    this.dispatchTransformedGenericPointerEvent(event, child);
                    event.setHoverExitPending(hoverExitPending);
                }
                event.setAction(10);
                this.dispatchTransformedGenericPointerEvent(event, child);
                event.setAction(action);
            }
            HoverTarget nextOldHoverTarget = firstOldHoverTarget.next;
            firstOldHoverTarget.recycle();
            firstOldHoverTarget = nextOldHoverTarget;
        }
        boolean bl = newHoveredSelf = !handled && action != 10 && !event.isHoverExitPending();
        if (newHoveredSelf == this.mHoveredSelf) {
            if (newHoveredSelf) {
                handled = super.dispatchHoverEvent(event);
            }
        } else {
            if (this.mHoveredSelf) {
                if (action == 10) {
                    handled |= super.dispatchHoverEvent(event);
                } else {
                    if (action == 7) {
                        super.dispatchHoverEvent(event);
                    }
                    event.setAction(10);
                    super.dispatchHoverEvent(event);
                    event.setAction(action);
                }
                this.mHoveredSelf = false;
            }
            if (newHoveredSelf) {
                if (action == 9) {
                    handled = super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                } else if (action == 7) {
                    event.setAction(9);
                    handled = super.dispatchHoverEvent(event);
                    event.setAction(action);
                    handled |= super.dispatchHoverEvent(event);
                    this.mHoveredSelf = true;
                }
            }
        }
        return handled;
    }

    private boolean dispatchTransformedGenericPointerEvent(MotionEvent event, View child) {
        float offsetX = this.getScrollX() - (float)child.mLeft;
        float offsetY = this.getScrollY() - (float)child.mTop;
        event.offsetLocation(offsetX, offsetY);
        boolean handled = child.dispatchGenericMotionEvent(event);
        event.offsetLocation(-offsetX, -offsetY);
        return handled;
    }

    public boolean onInterceptHoverEvent(MotionEvent event) {
        return false;
    }

    @Override
    protected boolean dispatchGenericPointerEvent(MotionEvent event) {
        int childrenCount = this.mChildrenCount;
        if (childrenCount != 0) {
            float x = event.getX();
            float y = event.getY();
            boolean customOrder = this.isChildrenDrawingOrderEnabled();
            View[] children = this.mChildren;
            for (int i = childrenCount - 1; i >= 0; --i) {
                int childIndex = this.getAndVerifyPreorderedIndex(childrenCount, i, customOrder);
                View child = ViewGroup.getAndVerifyPreorderedView(null, children, childIndex);
                if (!child.canReceivePointerEvents() || !this.isTransformedTouchPointInView(x, y, child, null) || !this.dispatchTransformedGenericPointerEvent(event, child)) continue;
                return true;
            }
        }
        return super.dispatchGenericPointerEvent(event);
    }

    private static View getAndVerifyPreorderedView(ArrayList<View> preorderedList, View[] children, int childIndex) {
        View child;
        if (preorderedList != null) {
            child = preorderedList.get(childIndex);
            if (child == null) {
                throw new RuntimeException("Invalid preorderedList contained null child at index " + childIndex);
            }
        } else {
            child = children[childIndex];
        }
        return child;
    }

    private void resetTouchState() {
    }

    private static boolean resetCancelNextUpFlag(@Nonnull View view) {
        if ((view.mPrivateFlags & 0x4000000) != 0) {
            view.mPrivateFlags &= 0xFBFFFFFF;
            return true;
        }
        return false;
    }

    private void clearTouchTargets() {
        TouchTarget target = this.mFirstTouchTarget;
        if (target != null) {
            TouchTarget next;
            do {
                next = target.next;
                target.recycle();
            } while ((target = next) != null);
            this.mFirstTouchTarget = null;
        }
    }

    private void cancelAndClearTouchTargets(MotionEvent event) {
        if (this.mFirstTouchTarget != null) {
            boolean syntheticEvent = false;
            if (event == null) {
                long time = Util.func_211178_c();
                syntheticEvent = true;
            }
            TouchTarget target = this.mFirstTouchTarget;
            while (target != null) {
                ViewGroup.resetCancelNextUpFlag(target.child);
                target = target.next;
            }
            this.clearTouchTargets();
            if (syntheticEvent) {
                event.recycle();
            }
        }
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean canceled;
        boolean intercepted;
        boolean handled = false;
        int action = ev.getAction();
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.cancelAndClearTouchTargets(ev);
            this.resetTouchState();
        }
        if (actionMasked == 0 || this.mFirstTouchTarget != null) {
            boolean allowIntercept;
            boolean bl = allowIntercept = (this.mGroupFlags & 0x80000) == 0;
            if (allowIntercept) {
                intercepted = this.onInterceptTouchEvent(ev);
                ev.setAction(action);
            } else {
                intercepted = false;
            }
        } else {
            intercepted = true;
        }
        boolean bl = canceled = ViewGroup.resetCancelNextUpFlag(this) || actionMasked == 3;
        if (canceled || !intercepted) {
            // empty if block
        }
        return handled;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return ev.getAction() == 0 && ev.isButtonPressed(1) && this.isOnScrollbarThumb(ev.getX(), ev.getY());
    }

    @Override
    public float getScrollX() {
        return 0.0f;
    }

    @Override
    public float getScrollY() {
        return 0.0f;
    }

    private float[] getTempLocationF() {
        if (this.mTempPosition == null) {
            this.mTempPosition = new float[2];
        }
        return this.mTempPosition;
    }

    boolean isTransformedTouchPointInView(float x, float y, View child, float[] outLocalPoint) {
        float[] point = this.getTempLocationF();
        point[0] = x;
        point[1] = y;
        this.transformPointToViewLocal(point, child);
        boolean isInView = child.pointInView(point[0], point[1]);
        if (isInView && outLocalPoint != null) {
            outLocalPoint[0] = point[0];
            outLocalPoint[1] = point[1];
        }
        return isInView;
    }

    void transformPointToViewLocal(float[] point, View child) {
        point[0] = point[0] + (this.getScrollX() - (float)child.mLeft);
        point[1] = point[1] + (this.getScrollY() - (float)child.mTop);
    }

    public void addView(@Nonnull View child) {
        this.addView(child, -1);
    }

    public void addView(@Nonnull View child, int index) {
        LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = this.createDefaultLayoutParams();
        }
        this.addView(child, index, params);
    }

    public void addView(@Nonnull View child, int width, int height) {
        LayoutParams params = this.createDefaultLayoutParams();
        params.width = width;
        params.height = height;
        this.addView(child, -1, params);
    }

    public void addView(@Nonnull View child, @Nonnull LayoutParams params) {
        this.addView(child, -1, params);
    }

    public void addView(@Nonnull View child, int index, @Nonnull LayoutParams params) {
        this.addViewInner(child, index, params);
    }

    private void addViewInner(@Nonnull View child, int index, @Nonnull LayoutParams params) {
        if (child.getParent() != null) {
            ModernUI.LOGGER.fatal(UIManager.MARKER, "Failed to add child view {} to {}. The child has already a parent.", (Object)child, (Object)this);
            return;
        }
        this.requestLayout();
        if (!this.checkLayoutParams(params)) {
            params = this.convertLayoutParams(params);
        }
        child.setLayoutParams(params);
        if (index < 0) {
            index = this.mChildrenCount;
        }
        this.addInArray(child, index);
        child.assignParent(this);
        ViewRootImpl viewRoot = this.viewRoot;
        if (viewRoot != null) {
            child.dispatchAttachedToWindow(viewRoot);
        }
    }

    public View getChildAt(int index) {
        if (index < 0 || index >= this.mChildrenCount) {
            return null;
        }
        return this.mChildren[index];
    }

    public int getChildCount() {
        return this.mChildrenCount;
    }

    private void addInArray(@Nonnull View child, int index) {
        View[] views = this.mChildren;
        int count = this.mChildrenCount;
        int size = views.length;
        if (index == count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(views, 0, this.mChildren, 0, size);
                views = this.mChildren;
            }
            views[this.mChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mChildren = new View[size + 12];
                System.arraycopy(views, 0, this.mChildren, 0, index);
                System.arraycopy(views, index, this.mChildren, index + 1, count - index);
                views = this.mChildren;
            } else {
                System.arraycopy(views, index, views, index + 1, count - index);
            }
            views[index] = child;
            ++this.mChildrenCount;
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    public void removeAllViews() {
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public void removeAllViewsInLayout() {
        int count = this.mChildrenCount;
        if (count <= 0) {
            return;
        }
        View[] children = this.mChildren;
        this.mChildrenCount = 0;
        for (int i = count - 1; i >= 0; --i) {
            View view = children[i];
            children[i] = null;
        }
    }

    @Override
    @Nullable
    final <T extends View> T findViewTraversal(int id) {
        if (id == this.mId) {
            return (T)this;
        }
        View[] views = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            Object view = views[i].findViewTraversal(id);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    private void setBooleanFlag(int flag, boolean value) {
        this.mGroupFlags = value ? (this.mGroupFlags |= flag) : (this.mGroupFlags &= ~flag);
    }

    protected boolean isChildrenDrawingOrderEnabled() {
        return (this.mGroupFlags & 0x400) == 1024;
    }

    protected void setChildrenDrawingOrderEnabled(boolean enabled) {
        this.setBooleanFlag(1024, enabled);
    }

    protected int getChildDrawingOrder(int childCount, int drawingPosition) {
        return drawingPosition;
    }

    public final int getChildDrawingOrder(int drawingPosition) {
        return this.getChildDrawingOrder(this.getChildCount(), drawingPosition);
    }

    public void setAddStatesFromChildren(boolean addsStates) {
        this.mGroupFlags = addsStates ? (this.mGroupFlags |= 0x2000) : (this.mGroupFlags &= 0xFFFFDFFF);
        this.refreshDrawableState();
    }

    public boolean addStatesFromChildren() {
        return (this.mGroupFlags & 0x2000) != 0;
    }

    @Override
    public void childDrawableStateChanged(View child) {
        if ((this.mGroupFlags & 0x2000) != 0) {
            this.refreshDrawableState();
        }
    }

    protected void measureChildren(int widthMeasureSpec, int heightMeasureSpec) {
        int size = this.mChildrenCount;
        View[] children = this.mChildren;
        for (int i = 0; i < size; ++i) {
            View child = children[i];
            if (child.getVisibility() == 2) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void measureChild(@Nonnull View child, int parentWidthSpec, int parentHeightSpec) {
        LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthSpec, 0, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightSpec, 0, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(@Nonnull View child, int parentWidthSpec, int widthUsed, int parentHeightSpec, int heightUsed) {
        MarginLayoutParams lp = (MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = ViewGroup.getChildMeasureSpec(parentWidthSpec, lp.leftMargin + lp.rightMargin + widthUsed, lp.width);
        int childHeightMeasureSpec = ViewGroup.getChildMeasureSpec(parentHeightSpec, lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public static int getChildMeasureSpec(int spec, int padding, int childDimension) {
        int specSize = MeasureSpec.getSize(spec);
        int size = Math.max(0, specSize - padding);
        int resultSize = 0;
        MeasureSpec.Mode resultMode = MeasureSpec.Mode.UNSPECIFIED;
        switch (MeasureSpec.getMode(spec)) {
            case EXACTLY: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = MeasureSpec.Mode.EXACTLY;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = MeasureSpec.Mode.EXACTLY;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = MeasureSpec.Mode.AT_MOST;
                break;
            }
            case AT_MOST: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = MeasureSpec.Mode.EXACTLY;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = MeasureSpec.Mode.AT_MOST;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = MeasureSpec.Mode.AT_MOST;
                break;
            }
            case UNSPECIFIED: {
                if (childDimension >= 0) {
                    resultSize = childDimension;
                    resultMode = MeasureSpec.Mode.EXACTLY;
                    break;
                }
                if (childDimension == -1) {
                    resultSize = size;
                    resultMode = MeasureSpec.Mode.UNSPECIFIED;
                    break;
                }
                if (childDimension != -2) break;
                resultSize = size;
                resultMode = MeasureSpec.Mode.UNSPECIFIED;
            }
        }
        return MeasureSpec.makeMeasureSpec(resultSize, resultMode);
    }

    @Override
    final void dispatchAttachedToWindow(ViewRootImpl viewRoot) {
        super.dispatchAttachedToWindow(viewRoot);
    }

    @Override
    protected void tick(int ticks) {
        View[] views = this.mChildren;
        int count = this.mChildrenCount;
        for (int i = 0; i < count; ++i) {
            views[i].tick(ticks);
        }
    }

    @Nonnull
    protected LayoutParams convertLayoutParams(@Nonnull LayoutParams params) {
        return params;
    }

    @Nonnull
    protected LayoutParams createDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(@Nullable LayoutParams params) {
        return params != null;
    }

    private static final class TouchTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecyclerLock = new Object();
        private static TouchTarget sRecyclerTop;
        private static int sRecyclerUsed;
        public static final int ALL_POINTER_IDS = -1;
        public View child;
        public int pointerIdBits;
        public TouchTarget next;

        private TouchTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public static TouchTarget obtain(@Nonnull View child, int pointerIdBits) {
            TouchTarget target;
            Object object = sRecyclerLock;
            synchronized (object) {
                if (sRecyclerTop == null) {
                    target = new TouchTarget();
                } else {
                    target = sRecyclerTop;
                    sRecyclerTop = target.next;
                    --sRecyclerUsed;
                    target.next = null;
                }
            }
            target.child = child;
            target.pointerIdBits = pointerIdBits;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            if (this.child == null) {
                throw new IllegalStateException(this + " already recycled");
            }
            Object object = sRecyclerLock;
            synchronized (object) {
                if (sRecyclerUsed < 32) {
                    ++sRecyclerUsed;
                    this.next = sRecyclerTop;
                    sRecyclerTop = this;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    private static final class HoverTarget {
        private static final int MAX_RECYCLED = 32;
        private static final Object sRecyclerLock = new Object();
        private static HoverTarget sRecyclerTop;
        private static int sRecyclerUsed;
        public View child;
        public HoverTarget next;

        private HoverTarget() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public static HoverTarget obtain(@Nonnull View child) {
            HoverTarget target;
            Object object = sRecyclerLock;
            synchronized (object) {
                if (sRecyclerTop == null) {
                    target = new HoverTarget();
                } else {
                    target = sRecyclerTop;
                    sRecyclerTop = target.next;
                    --sRecyclerUsed;
                    target.next = null;
                }
            }
            target.child = child;
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            if (this.child == null) {
                throw new IllegalStateException(this + " already recycled");
            }
            Object object = sRecyclerLock;
            synchronized (object) {
                if (sRecyclerUsed < 32) {
                    ++sRecyclerUsed;
                    this.next = sRecyclerTop;
                    sRecyclerTop = this;
                } else {
                    this.next = null;
                }
                this.child = null;
            }
        }
    }

    public static class MarginLayoutParams
    extends LayoutParams {
        public int leftMargin;
        public int topMargin;
        public int rightMargin;
        public int bottomMargin;

        public MarginLayoutParams(int width, int height) {
            super(width, height);
        }

        public void setMargins(int left, int top, int right, int bottom) {
            this.leftMargin = ViewConfig.spToPx(left);
            this.topMargin = ViewConfig.spToPx(top);
            this.rightMargin = ViewConfig.spToPx(right);
            this.bottomMargin = ViewConfig.spToPx(bottom);
        }

        public MarginLayoutParams(@Nonnull MarginLayoutParams source) {
            super(source.width, source.height);
            this.leftMargin = source.leftMargin;
            this.topMargin = source.topMargin;
            this.rightMargin = source.rightMargin;
            this.bottomMargin = source.bottomMargin;
        }

        public MarginLayoutParams(@Nonnull LayoutParams source) {
            super(source);
        }

        @Override
        @Nonnull
        public MarginLayoutParams copy() {
            return new MarginLayoutParams(this);
        }
    }

    public static class LayoutParams {
        public static final int MATCH_PARENT = -1;
        public static final int WRAP_CONTENT = -2;
        public int width;
        public int height;

        public LayoutParams(int width, int height) {
            this.width = width >= 0 ? ViewConfig.spToPx(width) : width;
            this.height = height >= 0 ? ViewConfig.spToPx(height) : height;
        }

        public LayoutParams(@Nonnull LayoutParams source) {
            this.width = source.width;
            this.height = source.height;
        }

        @Nonnull
        public LayoutParams copy() {
            return new LayoutParams(this);
        }
    }
}

